local assets=
{
	Asset("ANIM", "anim/frozen_heart.zip"),
	Asset("ATLAS", "images/inventoryimages/frozen_heart.xml")
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("cutstone")
    inst.AnimState:SetBuild("frozen_heart")
    inst.AnimState:PlayAnimation("idle")
    
	inst:AddComponent("edible") 
	inst.components.edible.healthvalue = 5	
	inst.components.edible.hungerhvalue = 2 --- It doesn't matter. Game hates me here and regen 10 hunger always.
    inst.components.edible.sanityvalue = 5
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/frozen_heart.xml"

	inst:AddComponent("inspectable")
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 20	
	
    return inst
end

return Prefab( "common/inventory/frozen_heart", fn, assets)